<?php

/**
 * List of sidebar navigations
 */
$sidebarNavs =
  [
    'Home',
    [
      'name' => 'Dashboard',
      'link' => '/admin/dashboard',
      'icon' => 'ti ti-layout-dashboard'
    ],
    'Transaksi',
    [
      'name' => 'Peminjaman',
      'link' => '/admin/loans',
      'icon' => 'ti ti-arrows-exchange'
    ],
    [
      'name' => 'Pengembalian',
      'link' => '/admin/returns',
      'icon' => 'ti ti-check'
    ],
    [
      'name' => 'Denda',
      'link' => '/admin/fines',
      'icon' => 'ti ti-report-money'
    ],
    'Master',
    [
      'name' => 'Anggota',
      'link' => '/admin/members',
      'icon' => 'ti ti-user'
    ],
    [
      'name' => 'Buku',
      'link' => '/admin/books',
      'icon' => 'ti ti-book'
    ],
    [
      'name' => 'Kategori',
      'link' => '/admin/categories',
      'icon' => 'ti ti-category-2'
    ],
    [
      'name' => 'Rak',
      'link' => '/admin/racks',
      'icon' => 'ti ti-columns'
    ],
  ];

if (auth()->user()->inGroup('superadmin') ?? false) {
  $sidebarNavs = array_merge(
    $sidebarNavs,
    [
      'Manajemen Akun',
      [
        'name' => 'Admin',
        'link' => '/admin/users',
        'icon' => 'ti ti-user-cog'
      ]
    ]
  );
}
?>

<!-- Sidebar Start -->
<aside class="left-sidebar bg-light shadow-sm">
  <!-- Sidebar scroll -->
  <div class="h-100 d-flex flex-column">
    <!-- Brand -->
    <div class="brand-logo d-flex align-items-center justify-content-between p-3 border-bottom">
      <a href="<?= base_url(); ?>" class="d-flex align-items-center text-decoration-none">
        <h2 class="mb-0">PERPUSTAKAAN<span class="text-primary"></span></h2>
      </a>
      <button class="btn btn-sm btn-light d-xl-none d-block sidebartoggler" id="sidebarCollapse">
        <i class="ti ti-x fs-5"></i>
      </button>
    </div>

    <!-- Sidebar navigation -->
    <nav class="sidebar-nav flex-grow-1 overflow-auto" data-simplebar="">
      <ul id="sidebarnav" class="list-unstyled py-3">
        <?php foreach ($sidebarNavs as $nav) : ?>
          <?php if (gettype($nav) === 'string') : ?>
            <li class="nav-small-cap my-2 px-3 text-uppercase text-muted">
              <i class="ti ti-dots nav-small-cap-icon me-2"></i>
              <span><?= $nav; ?></span>
            </li>
          <?php else : ?>
            <li class="sidebar-item my-1">
              <a class="sidebar-link d-flex align-items-center p-2 rounded text-dark" href="<?= base_url($nav['link']) ?>" aria-expanded="false">
                <span class="me-3">
                  <i class="<?= $nav['icon']; ?> fs-5"></i>
                </span>
                <span><?= $nav['name']; ?></span>
              </a>
            </li>
          <?php endif; ?>
        <?php endforeach; ?>
      </ul>
    </nav>
    <!-- End Sidebar navigation -->
  </div>
  <!-- End Sidebar scroll -->
</aside>

<!--  Sidebar End -->