<!--  Header Start -->
<style>
  @media only screen and (max-width: 768px) {
    #navBtn {
      display: none;
    }
  }
</style>
<header class="app-header">
  <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
    <div class="container-fluid">
      <!-- Logo & Sidebar Toggle -->
      <a class="navbar-brand d-flex align-items-center" href="#">
        <i class="ti ti-menu-2 me-2 d-block d-xl-none" id="headerCollapse" role="button"></i>
        <span class="fw-bold">Library Admin</span>
      </a>

      <!-- Collapsible Content -->
      <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
        <ul class="navbar-nav align-items-center gap-3">
          <!-- Loan Button -->
          <li class="nav-item">
            <a href="<?= base_url('admin/loans/new/members/search'); ?>" target="_blank" class="btn btn-primary btn-sm px-4">
              Ajukan Peminjaman
            </a>
          </li>

          <!-- Return Button -->
          <li class="nav-item">
            <a href="<?= base_url('admin/returns/new/search'); ?>" class="btn btn-outline-primary btn-sm px-4">
              Pengembalian Buku
            </a>
          </li>

          <!-- Fine Payment Button -->
          <li class="nav-item">
            <a href="<?= base_url('admin/fines/returns/search'); ?>" class="btn btn-outline-warning btn-sm px-4">
              Bayar Denda
            </a>
          </li>

          <!-- Fine Settings (Superadmin only) -->
          <?php if (auth()->user()->inGroup('superadmin')) : ?>
            <li class="nav-item">
              <a href="<?= base_url('admin/fines/settings'); ?>" class="btn btn-outline-danger btn-sm px-4">
                Pengaturan Denda
              </a>
            </li>
          <?php endif; ?>

          <!-- User Profile Dropdown -->
          <li class="nav-item dropdown">
            <a class="nav-link d-flex align-items-center" href="#" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
              <div class="d-flex align-items-center">
                <img src="https://via.placeholder.com/35" alt="Profile" class="rounded-circle me-2" style="width: 35px; height: 35px;">
                <i class="ti ti-chevron-down text-muted"></i>
              </div>
            </a>
            <ul class="dropdown-menu dropdown-menu-end border-0 shadow" aria-labelledby="profileDropdown" style="min-width: 250px;">
              <li class="dropdown-item">
                <strong>Profil</strong>
                <div class="mt-2">
                  <span>Username: <b><?= auth()->user()->username; ?></b></span><br>
                  <span>Email: <b><?= auth()->user()->email; ?></b></span><br>
                  <span>Level: </span>
                  <?php
                  $userGroup = auth()->user()->getGroups()[0];
                  ?>
                  <?php if ($userGroup === 'superadmin') : ?>
                    <span class="badge bg-success text-dark fw-semibold"><?= $userGroup; ?></span>
                  <?php elseif ($userGroup === 'admin') : ?>
                    <span class="badge bg-primary"><?= $userGroup; ?></span>
                  <?php else : ?>
                    <span class="badge bg-dark"><?= $userGroup; ?></span>
                  <?php endif; ?>
                </div>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li><a href="<?= base_url('logout'); ?>" class="dropdown-item text-danger">Logout</a></li>
            </ul>
          </li>
        </ul>
      </div>
    </div>
  </nav>
</header>

<!--  Header End -->