<?= $this->extend('layouts/admin_layout') ?>

<?= $this->section('head') ?>
<title>Dashboard</title>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row">
  <!-- BOOKS -->
  <div class="col-lg-3 col-sm-6">
    <a href="<?= base_url('admin/books'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-book"></i>
          </h2>
          <h3 class="text-dark">
            <?= count($books); ?> Buku
          </h3>
        </div>
      </div>
    </a>
  </div>
  <!-- BOOK STOCK -->
  <div class="col-lg-3 col-sm-6">
    <a href="<?= base_url('admin/books'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-database"></i>
          </h2>
          <h3 class="text-dark">
            <?= $totalBookStock; ?> Stok Buku
          </h3>
        </div>
      </div>
    </a>
  </div>
  <!-- RACKS -->
  <div class="col-lg-3 col-6">
    <a href="<?= base_url('admin/racks'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-columns"></i>
          </h2>
          <h3 class="text-dark">
            <?= count($racks); ?> Rak Buku
          </h3>
        </div>
      </div>
    </a>
  </div>
  <!-- CATEGORIES -->
  <div class="col-lg-3 col-6">
    <a href="<?= base_url('admin/categories'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-category-2"></i>
          </h2>
          <h3 class="text-dark">
            <?= count($categories); ?> Kategori
          </h3>
        </div>
      </div>
    </a>
  </div>
</div>

<div class="row">
  <!-- MEMBER -->
  <div class="col-sm-6">
    <a href="<?= base_url('admin/members'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-user"></i>
          </h2>
          <h3 class="text-dark">
            <?= count($members); ?> Anggota
          </h3>
        </div>
      </div>
    </a>
  </div>
  <!-- LOANS -->
  <div class="col-sm-6">
    <a href="<?= base_url('admin/loans'); ?>" class="text-decoration-none">
      <div class="card border-0 shadow-sm">
        <div class="card-body text-center">
          <h2 class="text-primary">
            <i class="ti ti-arrows-exchange"></i>
          </h2>
          <h3 class="text-dark">
            <?= count($loans); ?> Transaksi Peminjaman
          </h3>
        </div>
      </div>
    </a>
  </div>
</div>

<!-- REPORT TODAY -->
<div class="row">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-header bg-primary text-white">
        <h3 class="card-title mb-0"><b>Laporan Hari Ini</b></h3>
        <small><?= $dateNow->toLocalizedString('d MMMM Y'); ?></small>
      </div>
      <div class="card-body">
        <div class="row text-center">
          <div class="col-6 col-md-3">
            <h4 class="text-success"><b>Anggota Baru</b></h4>
            <h3><?= count($newMembersToday) ?></h3>
          </div>
          <div class="col-6 col-md-3">
            <h4 class="text-info"><b>Peminjaman</b></h4>
            <h3><?= count($newLoansToday) ?></h3>
          </div>
          <div class="col-6 col-md-3">
            <h4 class="text-info"><b>Pengembalian</b></h4>
            <h3><?= count($newBookReturnsToday) ?></h3>
          </div>
          <div class="col-6 col-md-3">
            <h4 class="text-danger"><b>Jatuh Tempo</b></h4>
            <h3><?= count($returnDueToday) ?></h3>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <!-- OVERVIEW CHART -->
  <div class="col-lg-8">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h5 class="card-title fw-semibold">Ikhtisar 7 hari terakhir</h5>
        <div id="chart"></div>
      </div>
    </div>
  </div>
  <div class="col-lg-4">
    <div class="row">
      <!-- FINE INCOME -->
      <div class="col-lg-12">
        <div class="card border-0 shadow-sm">
          <div class="card-body">
            <h5 class="card-title fw-semibold">Total Pendapatan Denda</h5>
            <div class="row align-items-center">
              <div class="col-9">
                <h4 class="fw-semibold">Rp<?= $fineIncomeThisMonth['value'] ?? 0; ?></h4>
                <small><?= $dateNow->toLocalizedString('MMMM Y'); ?></small>
              </div>
              <div class="col-3 text-end">
                <div class="bg-success text-white rounded-circle p-3 d-flex align-items-center justify-content-center">
                  <i class="ti ti-currency-dollar"></i>
                </div>
              </div>
            </div>
            <div class="row mt-3">
              <?php
              $thisMonth = $fineIncomeThisMonth['value'];
              $lastMonth = $fineIncomeLastMonth['value'];
              $percentage = ($lastMonth == 0) ? 0 : round(($thisMonth - $lastMonth) / $lastMonth * 100);
              ?>
              <div class="d-flex align-items-center">
                <span class="me-2 rounded-circle <?= $percentage >= 0 ? 'bg-light-success' : 'bg-light-danger'; ?> p-2 d-flex align-items-center justify-content-center">
                  <i class="ti <?= $percentage >= 0 ? 'ti-arrow-up-left text-success' : 'ti-arrow-down-left text-danger'; ?> "></i>
                </span>
                <p class="mb-0">
                  <?= ($percentage >= 0 ? '+' : '') . $percentage; ?>% dari bulan sebelumnya
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- TOTAL ARREARS -->
      <!-- TOTAL TUNGGAKAN -->
      <div class="col-lg-12">
        <div class="card overflow-hidden">
          <div class="card-body">
            <div class="row align-items-start">
              <div class="col-9">
                <h5 class="card-title mb-9 fw-semibold"> Total Tunggakan </h5>
                <h4 class="fw-semibold mb-3">Rp<?= $totalArrears; ?></h4>
                <div class="d-flex align-items-center">
                  <div class="me-4">
                    <span class="fs-2">
                      <?= "{$oldestFineDate->toLocalizedString('d MMMM Y')} - {$dateNow->toLocalizedString('d MMMM Y')}"; ?>
                    </span>
                  </div>
                </div>
              </div>
              <div class="col-3">
                <div class="d-flex justify-content-end">
                  <div class="text-white bg-danger rounded-circle p-6 d-flex align-items-center justify-content-center">
                    <i class="ti ti-currency-dollar fs-6"></i>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mt-3"></div>
          </div>
          <div id="arrears"></div>
        </div>
      </div>
    </div>
  </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="<?= base_url("assets/libs/apexcharts/apexcharts.min.js") ?>"></script>
<script>
  $(function() {
    // =====================================
    // Overview
    // =====================================
    const newMembersData = [
      <?php foreach ($newMembersOverview as $value) : ?>
        <?= "'{$value}', "; ?>
      <?php endforeach; ?>
    ].map((value => parseInt(value)));

    const loansData = [
      <?php foreach ($loansOverview as $value) : ?>
        <?= "'{$value}', "; ?>
      <?php endforeach; ?>
    ].map((value => parseInt(value)));

    const returnsData = [
      <?php foreach ($returnsOverview as $value) : ?>
        <?= "'{$value}', "; ?>
      <?php endforeach; ?>
    ].map((value => parseInt(value)));

    const highestValue = Math.max(
      Math.max(...newMembersData),
      Math.max(...loansData),
      Math.max(...returnsData)
    );

    var chart = {
      series: [{
          name: "Anggota baru",
          type: 'bar',
          data: newMembersData
        },
        {
          name: "Transaksi peminjaman",
          type: 'bar',
          data: loansData
        },
        {
          name: "Transaksi pengembalian",
          type: 'bar',
          data: returnsData
        },
      ],
      chart: {
        type: "bar",
        height: 400,
        offsetX: -15,
        toolbar: {
          show: true
        },
        foreColor: "#adb0bb",
        fontFamily: 'inherit',
        sparkline: {
          enabled: false
        },
      },
      plotOptions: {
        bar: {
          columnWidth: '80%',
          dataLabels: {
            position: 'top',
          }
        }
      },
      colors: ["#40dfb0", "#3849b9", "#db50c0"],
      markers: {
        size: 0
      },
      dataLabels: {
        enabled: false,
        offsetY: -17,
        style: {
          colors: ['#666666']
        },
      },
      legend: {
        show: true
      },
      grid: {
        borderColor: "rgba(0,0,0,0.1)",
        strokeDashArray: 3,
        xaxis: {
          lines: {
            show: false,
          },
        },
      },
      xaxis: {
        type: "category",
        categories: [
          <?php foreach ($lastWeekDateStringRange as $value) : ?>
            <?= "'{$value}', "; ?>
          <?php endforeach; ?>
        ],
        labels: {
          style: {
            cssClass: "fill-color"
          },
        },
      },
      yaxis: {
        show: true,
        min: 0,
        max: () => {
          const roundedHighestValue = (Math.ceil(highestValue / 10) * 10);

          if (roundedHighestValue <= 30) {
            return roundedHighestValue + 5;
          } else {
            return roundedHighestValue + 10;
          }
        },
        tickAmount: 5,
        labels: {
          style: {
            cssClass: "fill-color",
          },
        },
      },
      tooltip: {
        theme: "light"
      },
      responsive: [{
        breakpoint: 600,
        options: {
          plotOptions: {
            bar: {
              columnWidth: '100%',
            }
          },
          dataLabels: {
            enabled: false,
          },
        }
      }]
    };
    new ApexCharts(document.querySelector("#chart"), chart).render();

    // =====================================
    // FINES
    // =====================================
    var fines = {
      chart: {
        type: "area",
        height: 60,
        sparkline: {
          enabled: true,
        },
        group: "sparklines",
        fontFamily: "Plus Jakarta Sans', sans-serif",
        foreColor: "#49ca74",
      },
      series: [{
        name: "Denda terkumpul",
        color: "#49ca74",
        data: [<?= $fineIncomeLastMonth['value']; ?>, <?= $fineIncomeThisMonth['value']; ?>],
      }],
      xaxis: {
        type: "category",
        categories: ['<?= $fineIncomeLastMonth['month']; ?>', '<?= $fineIncomeThisMonth['month']; ?>'],
        labels: {
          style: {
            cssClass: "fill-color"
          },
        },
      },
      stroke: {
        curve: "smooth",
        width: 2,
      },
      fill: {
        colors: ["#f3feff"],
        type: "solid",
        opacity: 0.05,
      },
      markers: {
        size: 0,
      },
      tooltip: {
        theme: "dark",
        fixed: {
          enabled: true,
          position: "right",
        },
        x: {
          show: true,
        },
      },
    };
    new ApexCharts(document.querySelector("#fine"), fines).render();

    // =====================================
    // ARREARS
    // =====================================
    var arrears = {
      chart: {
        type: "area",
        height: 60,
        sparkline: {
          enabled: true,
        },
        group: "sparklines",
        fontFamily: "Plus Jakarta Sans', sans-serif",
        foreColor: "#ca495c",
      },
      series: [{
        name: "Total tunggakan (akumulasi)",
        color: "#ca495c",
        data: [
          <?php foreach ($arrears as $arrear) : ?>
            <?= "'{$arrear['arrear']}', "; ?>
          <?php endforeach; ?>
        ],
      }],
      xaxis: {
        type: "category",
        categories: [
          <?php foreach ($arrears as $arrear) : ?>
            <?= "'{$arrear['date']}', "; ?>
          <?php endforeach; ?>
        ],
        labels: {
          style: {
            cssClass: "fill-color"
          },
        },
      },
      stroke: {
        curve: "smooth",
        width: 2,
      },
      fill: {
        colors: ["#f3feff"],
        type: "solid",
        opacity: 0.05,
      },
      markers: {
        size: 0,
      },
      tooltip: {
        theme: "dark",
        fixed: {
          enabled: true,
          position: "right",
        },
        x: {
          show: true,
        },
      },
    };
    new ApexCharts(document.querySelector("#arrears"), arrears).render();
  })
</script>
<?= $this->endSection() ?>